package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ImageVersionNumber, ImageName}
import scala.jdk.CollectionConverters._
final case class DeleteImageVersionRequest(
    imageName: ImageName,
    version: ImageVersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest = {
    import DeleteImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .version(ImageVersionNumber.unwrap(version): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteImageVersionRequest.wrap(buildAwsValue())
}
object DeleteImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteImageVersionRequest =
      zio.aws.sagemaker.model.DeleteImageVersionRequest(imageName, version)
    def imageName: ImageName
    def version: ImageVersionNumber
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getVersion: ZIO[Any, Nothing, ImageVersionNumber] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest
  ) extends zio.aws.sagemaker.model.DeleteImageVersionRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val version: ImageVersionNumber =
      zio.aws.sagemaker.model.primitives.ImageVersionNumber(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest
  ): zio.aws.sagemaker.model.DeleteImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
