package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName
import scala.jdk.CollectionConverters._
final case class DeleteNotebookInstanceLifecycleConfigRequest(
    notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest = {
    import DeleteNotebookInstanceLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest
      .builder()
      .notebookInstanceLifecycleConfigName(
        NotebookInstanceLifecycleConfigName.unwrap(
          notebookInstanceLifecycleConfigName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object DeleteNotebookInstanceLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest =
      zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest(
        notebookInstanceLifecycleConfigName
      )
    def notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigName] =
      ZIO.succeed(notebookInstanceLifecycleConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest.ReadOnly {
    override val notebookInstanceLifecycleConfigName
        : NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName(
        impl.notebookInstanceLifecycleConfigName()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest
  ): zio.aws.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
