package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceName
import scala.jdk.CollectionConverters._
final case class DeleteNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest = {
    import DeleteNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteNotebookInstanceRequest.wrap(buildAwsValue())
}
object DeleteNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteNotebookInstanceRequest =
      zio.aws.sagemaker.model
        .DeleteNotebookInstanceRequest(notebookInstanceName)
    def notebookInstanceName: NotebookInstanceName
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.DeleteNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest
  ): zio.aws.sagemaker.model.DeleteNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
