package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName
import scala.jdk.CollectionConverters._
final case class DeleteStudioLifecycleConfigRequest(
    studioLifecycleConfigName: StudioLifecycleConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest = {
    import DeleteStudioLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest
      .builder()
      .studioLifecycleConfigName(
        StudioLifecycleConfigName.unwrap(
          studioLifecycleConfigName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteStudioLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteStudioLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object DeleteStudioLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteStudioLifecycleConfigRequest =
      zio.aws.sagemaker.model
        .DeleteStudioLifecycleConfigRequest(studioLifecycleConfigName)
    def studioLifecycleConfigName: StudioLifecycleConfigName
    def getStudioLifecycleConfigName
        : ZIO[Any, Nothing, StudioLifecycleConfigName] =
      ZIO.succeed(studioLifecycleConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.DeleteStudioLifecycleConfigRequest.ReadOnly {
    override val studioLifecycleConfigName: StudioLifecycleConfigName =
      zio.aws.sagemaker.model.primitives
        .StudioLifecycleConfigName(impl.studioLifecycleConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest
  ): zio.aws.sagemaker.model.DeleteStudioLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
