package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class DeleteTrialRequest(trialName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest = {
    import DeleteTrialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest
      .builder()
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteTrialRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteTrialRequest.wrap(buildAwsValue())
}
object DeleteTrialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteTrialRequest =
      zio.aws.sagemaker.model.DeleteTrialRequest(trialName)
    def trialName: ExperimentEntityName
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest
  ) extends zio.aws.sagemaker.model.DeleteTrialRequest.ReadOnly {
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest
  ): zio.aws.sagemaker.model.DeleteTrialRequest.ReadOnly = new Wrapper(impl)
}
