package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters._
final case class DescribeArtifactRequest(artifactArn: ArtifactArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest = {
    import DescribeArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest
      .builder()
      .artifactArn(ArtifactArn.unwrap(artifactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeArtifactRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeArtifactRequest.wrap(buildAwsValue())
}
object DescribeArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeArtifactRequest =
      zio.aws.sagemaker.model.DescribeArtifactRequest(artifactArn)
    def artifactArn: ArtifactArn
    def getArtifactArn: ZIO[Any, Nothing, ArtifactArn] =
      ZIO.succeed(artifactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest
  ) extends zio.aws.sagemaker.model.DescribeArtifactRequest.ReadOnly {
    override val artifactArn: ArtifactArn =
      zio.aws.sagemaker.model.primitives.ArtifactArn(impl.artifactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest
  ): zio.aws.sagemaker.model.DescribeArtifactRequest.ReadOnly = new Wrapper(
    impl
  )
}
