package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DescribeDeviceFleetRequest(deviceFleetName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest = {
    import DescribeDeviceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDeviceFleetRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeDeviceFleetRequest.wrap(buildAwsValue())
}
object DescribeDeviceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDeviceFleetRequest =
      zio.aws.sagemaker.model.DescribeDeviceFleetRequest(deviceFleetName)
    def deviceFleetName: EntityName
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest
  ) extends zio.aws.sagemaker.model.DescribeDeviceFleetRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest
  ): zio.aws.sagemaker.model.DescribeDeviceFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
