package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  DeviceFleetArn,
  DeviceFleetDescription,
  IotRoleAlias,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDeviceFleetResponse(
    deviceFleetName: EntityName,
    deviceFleetArn: DeviceFleetArn,
    outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig,
    description: Optional[DeviceFleetDescription] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    roleArn: Optional[RoleArn] = Optional.Absent,
    iotRoleAlias: Optional[IotRoleAlias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse = {
    import DescribeDeviceFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .deviceFleetArn(DeviceFleetArn.unwrap(deviceFleetArn): java.lang.String)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          DeviceFleetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        iotRoleAlias.map(value => IotRoleAlias.unwrap(value): java.lang.String)
      )(_.iotRoleAlias)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDeviceFleetResponse.wrap(buildAwsValue())
}
object DescribeDeviceFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDeviceFleetResponse =
      zio.aws.sagemaker.model.DescribeDeviceFleetResponse(
        deviceFleetName,
        deviceFleetArn,
        outputConfig.asEditable,
        description.map(value => value),
        creationTime,
        lastModifiedTime,
        roleArn.map(value => value),
        iotRoleAlias.map(value => value)
      )
    def deviceFleetName: EntityName
    def deviceFleetArn: DeviceFleetArn
    def outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    def description: Optional[DeviceFleetDescription]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def roleArn: Optional[RoleArn]
    def iotRoleAlias: Optional[IotRoleAlias]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getDeviceFleetArn: ZIO[Any, Nothing, DeviceFleetArn] =
      ZIO.succeed(deviceFleetArn)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getDescription: ZIO[Any, AwsError, DeviceFleetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getIotRoleAlias: ZIO[Any, AwsError, IotRoleAlias] =
      AwsError.unwrapOptionField("iotRoleAlias", iotRoleAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse
  ) extends zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val deviceFleetArn: DeviceFleetArn =
      zio.aws.sagemaker.model.primitives.DeviceFleetArn(impl.deviceFleetArn())
    override val outputConfig
        : zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.EdgeOutputConfig.wrap(impl.outputConfig())
    override val description: Optional[DeviceFleetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeviceFleetDescription(value)
        )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val iotRoleAlias: Optional[IotRoleAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.iotRoleAlias())
      .map(value => zio.aws.sagemaker.model.primitives.IotRoleAlias(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse
  ): zio.aws.sagemaker.model.DescribeDeviceFleetResponse.ReadOnly = new Wrapper(
    impl
  )
}
