package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  String1024,
  SecurityGroupId,
  FailureReason,
  DomainName,
  LastModifiedTime,
  DomainId,
  DomainArn,
  KmsKeyId,
  ResourceId,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDomainResponse(
    domainArn: Optional[DomainArn] = Optional.Absent,
    domainId: Optional[DomainId] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    homeEfsFileSystemId: Optional[ResourceId] = Optional.Absent,
    singleSignOnManagedApplicationInstanceId: Optional[String256] =
      Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.DomainStatus] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    authMode: Optional[zio.aws.sagemaker.model.AuthMode] = Optional.Absent,
    defaultUserSettings: Optional[zio.aws.sagemaker.model.UserSettings] =
      Optional.Absent,
    appNetworkAccessType: Optional[
      zio.aws.sagemaker.model.AppNetworkAccessType
    ] = Optional.Absent,
    homeEfsFileSystemKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    url: Optional[String1024] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    domainSettings: Optional[zio.aws.sagemaker.model.DomainSettings] =
      Optional.Absent,
    appSecurityGroupManagement: Optional[
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = Optional.Absent,
    securityGroupIdForDomainBoundary: Optional[SecurityGroupId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse = {
    import DescribeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
      .builder()
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        homeEfsFileSystemId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemId)
      .optionallyWith(
        singleSignOnManagedApplicationInstanceId.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.singleSignOnManagedApplicationInstanceId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(defaultUserSettings.map(value => value.buildAwsValue()))(
        _.defaultUserSettings
      )
      .optionallyWith(appNetworkAccessType.map(value => value.unwrap))(
        _.appNetworkAccessType
      )
      .optionallyWith(
        homeEfsFileSystemKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemKmsKeyId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        url.map(value => String1024.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(domainSettings.map(value => value.buildAwsValue()))(
        _.domainSettings
      )
      .optionallyWith(appSecurityGroupManagement.map(value => value.unwrap))(
        _.appSecurityGroupManagement
      )
      .optionallyWith(
        securityGroupIdForDomainBoundary.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.securityGroupIdForDomainBoundary)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDomainResponse.wrap(buildAwsValue())
}
object DescribeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDomainResponse =
      zio.aws.sagemaker.model.DescribeDomainResponse(
        domainArn.map(value => value),
        domainId.map(value => value),
        domainName.map(value => value),
        homeEfsFileSystemId.map(value => value),
        singleSignOnManagedApplicationInstanceId.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        failureReason.map(value => value),
        authMode.map(value => value),
        defaultUserSettings.map(value => value.asEditable),
        appNetworkAccessType.map(value => value),
        homeEfsFileSystemKmsKeyId.map(value => value),
        subnetIds.map(value => value),
        url.map(value => value),
        vpcId.map(value => value),
        kmsKeyId.map(value => value),
        domainSettings.map(value => value.asEditable),
        appSecurityGroupManagement.map(value => value),
        securityGroupIdForDomainBoundary.map(value => value)
      )
    def domainArn: Optional[DomainArn]
    def domainId: Optional[DomainId]
    def domainName: Optional[DomainName]
    def homeEfsFileSystemId: Optional[ResourceId]
    def singleSignOnManagedApplicationInstanceId: Optional[String256]
    def status: Optional[zio.aws.sagemaker.model.DomainStatus]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def failureReason: Optional[FailureReason]
    def authMode: Optional[zio.aws.sagemaker.model.AuthMode]
    def defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def appNetworkAccessType
        : Optional[zio.aws.sagemaker.model.AppNetworkAccessType]
    def homeEfsFileSystemKmsKeyId: Optional[KmsKeyId]
    def subnetIds: Optional[List[SubnetId]]
    def url: Optional[String1024]
    def vpcId: Optional[VpcId]
    def kmsKeyId: Optional[KmsKeyId]
    def domainSettings
        : Optional[zio.aws.sagemaker.model.DomainSettings.ReadOnly]
    def appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement]
    def securityGroupIdForDomainBoundary: Optional[SecurityGroupId]
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getHomeEfsFileSystemId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("homeEfsFileSystemId", homeEfsFileSystemId)
    def getSingleSignOnManagedApplicationInstanceId
        : ZIO[Any, AwsError, String256] = AwsError.unwrapOptionField(
      "singleSignOnManagedApplicationInstanceId",
      singleSignOnManagedApplicationInstanceId
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getDefaultUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("defaultUserSettings", defaultUserSettings)
    def getAppNetworkAccessType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AppNetworkAccessType] =
      AwsError.unwrapOptionField("appNetworkAccessType", appNetworkAccessType)
    def getHomeEfsFileSystemKmsKeyId: ZIO[Any, AwsError, KmsKeyId] = AwsError
      .unwrapOptionField("homeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getUrl: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("url", url)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDomainSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainSettings.ReadOnly] =
      AwsError.unwrapOptionField("domainSettings", domainSettings)
    def getAppSecurityGroupManagement: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = AwsError.unwrapOptionField(
      "appSecurityGroupManagement",
      appSecurityGroupManagement
    )
    def getSecurityGroupIdForDomainBoundary
        : ZIO[Any, AwsError, SecurityGroupId] = AwsError.unwrapOptionField(
      "securityGroupIdForDomainBoundary",
      securityGroupIdForDomainBoundary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ) extends zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly {
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.sagemaker.model.primitives.DomainArn(value))
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.sagemaker.model.primitives.DomainName(value))
    override val homeEfsFileSystemId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeEfsFileSystemId())
        .map(value => zio.aws.sagemaker.model.primitives.ResourceId(value))
    override val singleSignOnManagedApplicationInstanceId: Optional[String256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOnManagedApplicationInstanceId())
        .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val status: Optional[zio.aws.sagemaker.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.DomainStatus.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val authMode: Optional[zio.aws.sagemaker.model.AuthMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authMode())
        .map(value => zio.aws.sagemaker.model.AuthMode.wrap(value))
    override val defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultUserSettings())
        .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
    override val appNetworkAccessType
        : Optional[zio.aws.sagemaker.model.AppNetworkAccessType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appNetworkAccessType())
        .map(value => zio.aws.sagemaker.model.AppNetworkAccessType.wrap(value))
    override val homeEfsFileSystemKmsKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeEfsFileSystemKmsKeyId())
        .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SubnetId(item)
        }.toList
      )
    override val url: Optional[String1024] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.sagemaker.model.primitives.VpcId(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val domainSettings
        : Optional[zio.aws.sagemaker.model.DomainSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSettings())
        .map(value => zio.aws.sagemaker.model.DomainSettings.wrap(value))
    override val appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSecurityGroupManagement())
        .map(value =>
          zio.aws.sagemaker.model.AppSecurityGroupManagement.wrap(value)
        )
    override val securityGroupIdForDomainBoundary: Optional[SecurityGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIdForDomainBoundary())
        .map(value => zio.aws.sagemaker.model.primitives.SecurityGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ): zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly = new Wrapper(impl)
}
