package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HumanTaskUiName
import scala.jdk.CollectionConverters._
final case class DescribeHumanTaskUiRequest(humanTaskUiName: HumanTaskUiName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest = {
    import DescribeHumanTaskUiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest
      .builder()
      .humanTaskUiName(
        HumanTaskUiName.unwrap(humanTaskUiName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeHumanTaskUiRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeHumanTaskUiRequest.wrap(buildAwsValue())
}
object DescribeHumanTaskUiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeHumanTaskUiRequest =
      zio.aws.sagemaker.model.DescribeHumanTaskUiRequest(humanTaskUiName)
    def humanTaskUiName: HumanTaskUiName
    def getHumanTaskUiName: ZIO[Any, Nothing, HumanTaskUiName] =
      ZIO.succeed(humanTaskUiName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest
  ) extends zio.aws.sagemaker.model.DescribeHumanTaskUiRequest.ReadOnly {
    override val humanTaskUiName: HumanTaskUiName =
      zio.aws.sagemaker.model.primitives.HumanTaskUiName(impl.humanTaskUiName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest
  ): zio.aws.sagemaker.model.DescribeHumanTaskUiRequest.ReadOnly = new Wrapper(
    impl
  )
}
