package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.LabelingJobName
import scala.jdk.CollectionConverters._
final case class DescribeLabelingJobRequest(labelingJobName: LabelingJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest = {
    import DescribeLabelingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest
      .builder()
      .labelingJobName(
        LabelingJobName.unwrap(labelingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeLabelingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeLabelingJobRequest.wrap(buildAwsValue())
}
object DescribeLabelingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeLabelingJobRequest =
      zio.aws.sagemaker.model.DescribeLabelingJobRequest(labelingJobName)
    def labelingJobName: LabelingJobName
    def getLabelingJobName: ZIO[Any, Nothing, LabelingJobName] =
      ZIO.succeed(labelingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest
  ) extends zio.aws.sagemaker.model.DescribeLabelingJobRequest.ReadOnly {
    override val labelingJobName: LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName(impl.labelingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest
  ): zio.aws.sagemaker.model.DescribeLabelingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
