package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkteamArn
import scala.jdk.CollectionConverters._
final case class DescribeSubscribedWorkteamRequest(workteamArn: WorkteamArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest = {
    import DescribeSubscribedWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest
      .wrap(buildAwsValue())
}
object DescribeSubscribedWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest =
      zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest(workteamArn)
    def workteamArn: WorkteamArn
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest
  ) extends zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest
  ): zio.aws.sagemaker.model.DescribeSubscribedWorkteamRequest.ReadOnly =
    new Wrapper(impl)
}
