package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  FailureReason,
  LastModifiedTime,
  DomainId,
  EfsUid,
  UserProfileArn,
  SingleSignOnUserIdentifier,
  UserProfileName,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeUserProfileResponse(
    domainId: Optional[DomainId] = Optional.Absent,
    userProfileArn: Optional[UserProfileArn] = Optional.Absent,
    userProfileName: Optional[UserProfileName] = Optional.Absent,
    homeEfsFileSystemUid: Optional[EfsUid] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.UserProfileStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    singleSignOnUserIdentifier: Optional[SingleSignOnUserIdentifier] =
      Optional.Absent,
    singleSignOnUserValue: Optional[String256] = Optional.Absent,
    userSettings: Optional[zio.aws.sagemaker.model.UserSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse = {
    import DescribeUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileArn.map(value =>
          UserProfileArn.unwrap(value): java.lang.String
        )
      )(_.userProfileArn)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(
        homeEfsFileSystemUid.map(value =>
          EfsUid.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemUid)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        singleSignOnUserIdentifier.map(value =>
          SingleSignOnUserIdentifier.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserIdentifier)
      .optionallyWith(
        singleSignOnUserValue.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserValue)
      .optionallyWith(userSettings.map(value => value.buildAwsValue()))(
        _.userSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeUserProfileResponse.wrap(buildAwsValue())
}
object DescribeUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeUserProfileResponse =
      zio.aws.sagemaker.model.DescribeUserProfileResponse(
        domainId.map(value => value),
        userProfileArn.map(value => value),
        userProfileName.map(value => value),
        homeEfsFileSystemUid.map(value => value),
        status.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        singleSignOnUserIdentifier.map(value => value),
        singleSignOnUserValue.map(value => value),
        userSettings.map(value => value.asEditable)
      )
    def domainId: Optional[DomainId]
    def userProfileArn: Optional[UserProfileArn]
    def userProfileName: Optional[UserProfileName]
    def homeEfsFileSystemUid: Optional[EfsUid]
    def status: Optional[zio.aws.sagemaker.model.UserProfileStatus]
    def lastModifiedTime: Optional[LastModifiedTime]
    def creationTime: Optional[CreationTime]
    def failureReason: Optional[FailureReason]
    def singleSignOnUserIdentifier: Optional[SingleSignOnUserIdentifier]
    def singleSignOnUserValue: Optional[String256]
    def userSettings: Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileArn: ZIO[Any, AwsError, UserProfileArn] =
      AwsError.unwrapOptionField("userProfileArn", userProfileArn)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getHomeEfsFileSystemUid: ZIO[Any, AwsError, EfsUid] =
      AwsError.unwrapOptionField("homeEfsFileSystemUid", homeEfsFileSystemUid)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSingleSignOnUserIdentifier
        : ZIO[Any, AwsError, SingleSignOnUserIdentifier] =
      AwsError.unwrapOptionField(
        "singleSignOnUserIdentifier",
        singleSignOnUserIdentifier
      )
    def getSingleSignOnUserValue: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("singleSignOnUserValue", singleSignOnUserValue)
    def getUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ) extends zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileArn: Optional[UserProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileArn())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileArn(value))
    override val userProfileName: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileName())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val homeEfsFileSystemUid: Optional[EfsUid] = zio.aws.core.internal
      .optionalFromNullable(impl.homeEfsFileSystemUid())
      .map(value => zio.aws.sagemaker.model.primitives.EfsUid(value))
    override val status: Optional[zio.aws.sagemaker.model.UserProfileStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.UserProfileStatus.wrap(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val singleSignOnUserIdentifier
        : Optional[SingleSignOnUserIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.singleSignOnUserIdentifier())
      .map(value =>
        zio.aws.sagemaker.model.primitives.SingleSignOnUserIdentifier(value)
      )
    override val singleSignOnUserValue: Optional[String256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOnUserValue())
        .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val userSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSettings())
        .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse
  ): zio.aws.sagemaker.model.DescribeUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
