package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait DetailedModelPackageStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus
}
object DetailedModelPackageStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus
  ): zio.aws.sagemaker.model.DetailedModelPackageStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.NOT_STARTED =>
      val r = NotStarted
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DetailedModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotStarted
      extends zio.aws.sagemaker.model.DetailedModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.NOT_STARTED
  }
  case object InProgress
      extends zio.aws.sagemaker.model.DetailedModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.sagemaker.model.DetailedModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.COMPLETED
  }
  case object Failed
      extends zio.aws.sagemaker.model.DetailedModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedModelPackageStatus.FAILED
  }
}
