package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DriftCheckModelDataQuality(
    statistics: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent,
    constraints: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality = {
    import DriftCheckModelDataQuality.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality
      .builder()
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckModelDataQuality.wrap(buildAwsValue())
}
object DriftCheckModelDataQuality {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckModelDataQuality =
      zio.aws.sagemaker.model.DriftCheckModelDataQuality(
        statistics.map(value => value.asEditable),
        constraints.map(value => value.asEditable)
      )
    def statistics: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def constraints: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality
  ) extends zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly {
    override val statistics
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val constraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality
  ): zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly = new Wrapper(
    impl
  )
}
