package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AssociationEntityArn
import scala.jdk.CollectionConverters._
final case class Edge(
    sourceArn: Optional[AssociationEntityArn] = Optional.Absent,
    destinationArn: Optional[AssociationEntityArn] = Optional.Absent,
    associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Edge = {
    import Edge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Edge
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Edge.ReadOnly =
    zio.aws.sagemaker.model.Edge.wrap(buildAwsValue())
}
object Edge {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Edge] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Edge = zio.aws.sagemaker.model.Edge(
      sourceArn.map(value => value),
      destinationArn.map(value => value),
      associationType.map(value => value)
    )
    def sourceArn: Optional[AssociationEntityArn]
    def destinationArn: Optional[AssociationEntityArn]
    def associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType]
    def getSourceArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssociationEdgeType] =
      AwsError.unwrapOptionField("associationType", associationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Edge
  ) extends zio.aws.sagemaker.model.Edge.ReadOnly {
    override val sourceArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val destinationArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val associationType
        : Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationType())
        .map(value => zio.aws.sagemaker.model.AssociationEdgeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Edge
  ): zio.aws.sagemaker.model.Edge.ReadOnly = new Wrapper(impl)
}
