package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{EdgeVersion, EntityName}
import scala.jdk.CollectionConverters._
final case class EdgeModelStat(
    modelName: EntityName,
    modelVersion: EdgeVersion,
    offlineDeviceCount: Long,
    connectedDeviceCount: Long,
    activeDeviceCount: Long,
    samplingDeviceCount: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeModelStat = {
    import EdgeModelStat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeModelStat
      .builder()
      .modelName(EntityName.unwrap(modelName): java.lang.String)
      .modelVersion(EdgeVersion.unwrap(modelVersion): java.lang.String)
      .offlineDeviceCount(offlineDeviceCount: java.lang.Long)
      .connectedDeviceCount(connectedDeviceCount: java.lang.Long)
      .activeDeviceCount(activeDeviceCount: java.lang.Long)
      .samplingDeviceCount(samplingDeviceCount: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeModelStat.ReadOnly =
    zio.aws.sagemaker.model.EdgeModelStat.wrap(buildAwsValue())
}
object EdgeModelStat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeModelStat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeModelStat =
      zio.aws.sagemaker.model.EdgeModelStat(
        modelName,
        modelVersion,
        offlineDeviceCount,
        connectedDeviceCount,
        activeDeviceCount,
        samplingDeviceCount
      )
    def modelName: EntityName
    def modelVersion: EdgeVersion
    def offlineDeviceCount: Long
    def connectedDeviceCount: Long
    def activeDeviceCount: Long
    def samplingDeviceCount: Long
    def getModelName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, EdgeVersion] =
      ZIO.succeed(modelVersion)
    def getOfflineDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(offlineDeviceCount)
    def getConnectedDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(connectedDeviceCount)
    def getActiveDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(activeDeviceCount)
    def getSamplingDeviceCount: ZIO[Any, Nothing, Long] =
      ZIO.succeed(samplingDeviceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModelStat
  ) extends zio.aws.sagemaker.model.EdgeModelStat.ReadOnly {
    override val modelName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelName())
    override val modelVersion: EdgeVersion =
      zio.aws.sagemaker.model.primitives.EdgeVersion(impl.modelVersion())
    override val offlineDeviceCount: Long = impl.offlineDeviceCount(): Long
    override val connectedDeviceCount: Long = impl.connectedDeviceCount(): Long
    override val activeDeviceCount: Long = impl.activeDeviceCount(): Long
    override val samplingDeviceCount: Long = impl.samplingDeviceCount(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModelStat
  ): zio.aws.sagemaker.model.EdgeModelStat.ReadOnly = new Wrapper(impl)
}
