package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentParameter(
    key: String,
    valueType: String,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter = {
    import EnvironmentParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter
      .builder()
      .key(key: java.lang.String)
      .valueType(valueType: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly =
    zio.aws.sagemaker.model.EnvironmentParameter.wrap(buildAwsValue())
}
object EnvironmentParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EnvironmentParameter =
      zio.aws.sagemaker.model.EnvironmentParameter(key, valueType, value)
    def key: String
    def valueType: String
    def value: String
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValueType: ZIO[Any, Nothing, String] = ZIO.succeed(valueType)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter
  ) extends zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly {
    override val key: String = impl.key(): String
    override val valueType: String = impl.valueType(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EnvironmentParameter
  ): zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly = new Wrapper(impl)
}
