package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  FeatureGroupArn,
  FeatureGroupName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FeatureGroupSummary(
    featureGroupName: FeatureGroupName,
    featureGroupArn: FeatureGroupArn,
    creationTime: Timestamp,
    featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      Optional.Absent,
    offlineStoreStatus: Optional[zio.aws.sagemaker.model.OfflineStoreStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary = {
    import FeatureGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .featureGroupArn(
        FeatureGroupArn.unwrap(featureGroupArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(featureGroupStatus.map(value => value.unwrap))(
        _.featureGroupStatus
      )
      .optionallyWith(offlineStoreStatus.map(value => value.buildAwsValue()))(
        _.offlineStoreStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly =
    zio.aws.sagemaker.model.FeatureGroupSummary.wrap(buildAwsValue())
}
object FeatureGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureGroupSummary =
      zio.aws.sagemaker.model.FeatureGroupSummary(
        featureGroupName,
        featureGroupArn,
        creationTime,
        featureGroupStatus.map(value => value),
        offlineStoreStatus.map(value => value.asEditable)
      )
    def featureGroupName: FeatureGroupName
    def featureGroupArn: FeatureGroupArn
    def creationTime: Timestamp
    def featureGroupStatus: Optional[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getFeatureGroupArn: ZIO[Any, Nothing, FeatureGroupArn] =
      ZIO.succeed(featureGroupArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getFeatureGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField("featureGroupStatus", featureGroupStatus)
    def getOfflineStoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreStatus", offlineStoreStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary
  ) extends zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val featureGroupArn: FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn(impl.featureGroupArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val featureGroupStatus
        : Optional[zio.aws.sagemaker.model.FeatureGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupStatus())
        .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatus
        : Optional[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offlineStoreStatus())
        .map(value => zio.aws.sagemaker.model.OfflineStoreStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary
  ): zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly = new Wrapper(impl)
}
