package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  FailureReason,
  Timestamp,
  FlowDefinitionArn,
  FlowDefinitionName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FlowDefinitionSummary(
    flowDefinitionName: FlowDefinitionName,
    flowDefinitionArn: FlowDefinitionArn,
    flowDefinitionStatus: zio.aws.sagemaker.model.FlowDefinitionStatus,
    creationTime: Timestamp,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary = {
    import FlowDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary
      .builder()
      .flowDefinitionName(
        FlowDefinitionName.unwrap(flowDefinitionName): java.lang.String
      )
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .flowDefinitionStatus(flowDefinitionStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly =
    zio.aws.sagemaker.model.FlowDefinitionSummary.wrap(buildAwsValue())
}
object FlowDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FlowDefinitionSummary =
      zio.aws.sagemaker.model.FlowDefinitionSummary(
        flowDefinitionName,
        flowDefinitionArn,
        flowDefinitionStatus,
        creationTime,
        failureReason.map(value => value)
      )
    def flowDefinitionName: FlowDefinitionName
    def flowDefinitionArn: FlowDefinitionArn
    def flowDefinitionStatus: zio.aws.sagemaker.model.FlowDefinitionStatus
    def creationTime: Timestamp
    def failureReason: Optional[FailureReason]
    def getFlowDefinitionName: ZIO[Any, Nothing, FlowDefinitionName] =
      ZIO.succeed(flowDefinitionName)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getFlowDefinitionStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.FlowDefinitionStatus] =
      ZIO.succeed(flowDefinitionStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary
  ) extends zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly {
    override val flowDefinitionName: FlowDefinitionName =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionName(impl.flowDefinitionName())
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val flowDefinitionStatus
        : zio.aws.sagemaker.model.FlowDefinitionStatus =
      zio.aws.sagemaker.model.FlowDefinitionStatus
        .wrap(impl.flowDefinitionStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary
  ): zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly = new Wrapper(impl)
}
