package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  HumanTaskUiArn,
  HumanTaskUiName
}
import scala.jdk.CollectionConverters._
final case class HumanTaskUiSummary(
    humanTaskUiName: HumanTaskUiName,
    humanTaskUiArn: HumanTaskUiArn,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary = {
    import HumanTaskUiSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary
      .builder()
      .humanTaskUiName(
        HumanTaskUiName.unwrap(humanTaskUiName): java.lang.String
      )
      .humanTaskUiArn(HumanTaskUiArn.unwrap(humanTaskUiArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly =
    zio.aws.sagemaker.model.HumanTaskUiSummary.wrap(buildAwsValue())
}
object HumanTaskUiSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HumanTaskUiSummary =
      zio.aws.sagemaker.model
        .HumanTaskUiSummary(humanTaskUiName, humanTaskUiArn, creationTime)
    def humanTaskUiName: HumanTaskUiName
    def humanTaskUiArn: HumanTaskUiArn
    def creationTime: Timestamp
    def getHumanTaskUiName: ZIO[Any, Nothing, HumanTaskUiName] =
      ZIO.succeed(humanTaskUiName)
    def getHumanTaskUiArn: ZIO[Any, Nothing, HumanTaskUiArn] =
      ZIO.succeed(humanTaskUiArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary
  ) extends zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly {
    override val humanTaskUiName: HumanTaskUiName =
      zio.aws.sagemaker.model.primitives.HumanTaskUiName(impl.humanTaskUiName())
    override val humanTaskUiArn: HumanTaskUiArn =
      zio.aws.sagemaker.model.primitives.HumanTaskUiArn(impl.humanTaskUiArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary
  ): zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly = new Wrapper(impl)
}
