package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ImageVersionStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus
}
object ImageVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus
  ): zio.aws.sagemaker.model.ImageVersionStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATING
  }
  case object CREATED extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATED
  }
  case object CREATE_FAILED extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.CREATE_FAILED
  }
  case object DELETING extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.DELETING
  }
  case object DELETE_FAILED extends zio.aws.sagemaker.model.ImageVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus.DELETE_FAILED
  }
}
