package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  RecommendationJobName,
  RoleArn,
  Timestamp,
  FailureReason,
  LastModifiedTime,
  RecommendationJobArn,
  RecommendationJobDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InferenceRecommendationsJob(
    jobName: RecommendationJobName,
    jobDescription: RecommendationJobDescription,
    jobType: zio.aws.sagemaker.model.RecommendationJobType,
    jobArn: RecommendationJobArn,
    status: zio.aws.sagemaker.model.RecommendationJobStatus,
    creationTime: CreationTime,
    completionTime: Optional[Timestamp] = Optional.Absent,
    roleArn: RoleArn,
    lastModifiedTime: LastModifiedTime,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob = {
    import InferenceRecommendationsJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .jobDescription(
        RecommendationJobDescription.unwrap(jobDescription): java.lang.String
      )
      .jobType(jobType.unwrap)
      .jobArn(RecommendationJobArn.unwrap(jobArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionTime)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .lastModifiedTime(LastModifiedTime.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly =
    zio.aws.sagemaker.model.InferenceRecommendationsJob.wrap(buildAwsValue())
}
object InferenceRecommendationsJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceRecommendationsJob =
      zio.aws.sagemaker.model.InferenceRecommendationsJob(
        jobName,
        jobDescription,
        jobType,
        jobArn,
        status,
        creationTime,
        completionTime.map(value => value),
        roleArn,
        lastModifiedTime,
        failureReason.map(value => value)
      )
    def jobName: RecommendationJobName
    def jobDescription: RecommendationJobDescription
    def jobType: zio.aws.sagemaker.model.RecommendationJobType
    def jobArn: RecommendationJobArn
    def status: zio.aws.sagemaker.model.RecommendationJobStatus
    def creationTime: CreationTime
    def completionTime: Optional[Timestamp]
    def roleArn: RoleArn
    def lastModifiedTime: LastModifiedTime
    def failureReason: Optional[FailureReason]
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
    def getJobDescription: ZIO[Any, Nothing, RecommendationJobDescription] =
      ZIO.succeed(jobDescription)
    def getJobType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobType] =
      ZIO.succeed(jobType)
    def getJobArn: ZIO[Any, Nothing, RecommendationJobArn] = ZIO.succeed(jobArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getLastModifiedTime: ZIO[Any, Nothing, LastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob
  ) extends zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
    override val jobDescription: RecommendationJobDescription =
      zio.aws.sagemaker.model.primitives
        .RecommendationJobDescription(impl.jobDescription())
    override val jobType: zio.aws.sagemaker.model.RecommendationJobType =
      zio.aws.sagemaker.model.RecommendationJobType.wrap(impl.jobType())
    override val jobArn: RecommendationJobArn =
      zio.aws.sagemaker.model.primitives.RecommendationJobArn(impl.jobArn())
    override val status: zio.aws.sagemaker.model.RecommendationJobStatus =
      zio.aws.sagemaker.model.RecommendationJobStatus.wrap(impl.status())
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val completionTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val lastModifiedTime: LastModifiedTime =
      zio.aws.sagemaker.model.primitives
        .LastModifiedTime(impl.lastModifiedTime())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob
  ): zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly = new Wrapper(
    impl
  )
}
