package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ParameterValue
import scala.jdk.CollectionConverters._
final case class IntegerParameterRangeSpecification(
    minValue: ParameterValue,
    maxValue: ParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangeSpecification = {
    import IntegerParameterRangeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangeSpecification
      .builder()
      .minValue(ParameterValue.unwrap(minValue): java.lang.String)
      .maxValue(ParameterValue.unwrap(maxValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly =
    zio.aws.sagemaker.model.IntegerParameterRangeSpecification
      .wrap(buildAwsValue())
}
object IntegerParameterRangeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.IntegerParameterRangeSpecification =
      zio.aws.sagemaker.model
        .IntegerParameterRangeSpecification(minValue, maxValue)
    def minValue: ParameterValue
    def maxValue: ParameterValue
    def getMinValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(minValue)
    def getMaxValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(maxValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangeSpecification
  ) extends zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly {
    override val minValue: ParameterValue =
      zio.aws.sagemaker.model.primitives.ParameterValue(impl.minValue())
    override val maxValue: ParameterValue =
      zio.aws.sagemaker.model.primitives.ParameterValue(impl.maxValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangeSpecification
  ): zio.aws.sagemaker.model.IntegerParameterRangeSpecification.ReadOnly =
    new Wrapper(impl)
}
