package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxPercentageOfInputDatasetLabeled,
  MaxHumanLabeledObjectCount
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LabelingJobStoppingConditions(
    maxHumanLabeledObjectCount: Optional[MaxHumanLabeledObjectCount] =
      Optional.Absent,
    maxPercentageOfInputDatasetLabeled: Optional[
      MaxPercentageOfInputDatasetLabeled
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions = {
    import LabelingJobStoppingConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
      .builder()
      .optionallyWith(
        maxHumanLabeledObjectCount.map(value =>
          MaxHumanLabeledObjectCount.unwrap(value): Integer
        )
      )(_.maxHumanLabeledObjectCount)
      .optionallyWith(
        maxPercentageOfInputDatasetLabeled.map(value =>
          MaxPercentageOfInputDatasetLabeled.unwrap(value): Integer
        )
      )(_.maxPercentageOfInputDatasetLabeled)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobStoppingConditions.wrap(buildAwsValue())
}
object LabelingJobStoppingConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobStoppingConditions =
      zio.aws.sagemaker.model.LabelingJobStoppingConditions(
        maxHumanLabeledObjectCount.map(value => value),
        maxPercentageOfInputDatasetLabeled.map(value => value)
      )
    def maxHumanLabeledObjectCount: Optional[MaxHumanLabeledObjectCount]
    def maxPercentageOfInputDatasetLabeled
        : Optional[MaxPercentageOfInputDatasetLabeled]
    def getMaxHumanLabeledObjectCount
        : ZIO[Any, AwsError, MaxHumanLabeledObjectCount] =
      AwsError.unwrapOptionField(
        "maxHumanLabeledObjectCount",
        maxHumanLabeledObjectCount
      )
    def getMaxPercentageOfInputDatasetLabeled
        : ZIO[Any, AwsError, MaxPercentageOfInputDatasetLabeled] =
      AwsError.unwrapOptionField(
        "maxPercentageOfInputDatasetLabeled",
        maxPercentageOfInputDatasetLabeled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ) extends zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly {
    override val maxHumanLabeledObjectCount
        : Optional[MaxHumanLabeledObjectCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxHumanLabeledObjectCount())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MaxHumanLabeledObjectCount(value)
      )
    override val maxPercentageOfInputDatasetLabeled
        : Optional[MaxPercentageOfInputDatasetLabeled] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPercentageOfInputDatasetLabeled())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxPercentageOfInputDatasetLabeled(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions
  ): zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly =
    new Wrapper(impl)
}
