package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListAppImageConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    appImageConfigs: Optional[
      Iterable[zio.aws.sagemaker.model.AppImageConfigDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse = {
    import ListAppImageConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        appImageConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appImageConfigs)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAppImageConfigsResponse.wrap(buildAwsValue())
}
object ListAppImageConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAppImageConfigsResponse =
      zio.aws.sagemaker.model.ListAppImageConfigsResponse(
        nextToken.map(value => value),
        appImageConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def appImageConfigs
        : Optional[List[zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAppImageConfigs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("appImageConfigs", appImageConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse
  ) extends zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val appImageConfigs: Optional[
      List[zio.aws.sagemaker.model.AppImageConfigDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appImageConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AppImageConfigDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse
  ): zio.aws.sagemaker.model.ListAppImageConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
