package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  Timestamp,
  MaxResults,
  String256,
  AssociationEntityArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssociationsRequest(
    sourceArn: Optional[AssociationEntityArn] = Optional.Absent,
    destinationArn: Optional[AssociationEntityArn] = Optional.Absent,
    sourceType: Optional[String256] = Optional.Absent,
    destinationType: Optional[String256] = Optional.Absent,
    associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      Optional.Absent,
    createdAfter: Optional[Timestamp] = Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.SortAssociationsBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest = {
    import ListAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value =>
          AssociationEntityArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        sourceType.map(value => String256.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        destinationType.map(value => String256.unwrap(value): java.lang.String)
      )(_.destinationType)
      .optionallyWith(associationType.map(value => value.unwrap))(
        _.associationType
      )
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAssociationsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAssociationsRequest.wrap(buildAwsValue())
}
object ListAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAssociationsRequest =
      zio.aws.sagemaker.model.ListAssociationsRequest(
        sourceArn.map(value => value),
        destinationArn.map(value => value),
        sourceType.map(value => value),
        destinationType.map(value => value),
        associationType.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sourceArn: Optional[AssociationEntityArn]
    def destinationArn: Optional[AssociationEntityArn]
    def sourceType: Optional[String256]
    def destinationType: Optional[String256]
    def associationType: Optional[zio.aws.sagemaker.model.AssociationEdgeType]
    def createdAfter: Optional[Timestamp]
    def createdBefore: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.SortAssociationsBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSourceArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, AssociationEntityArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getSourceType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getDestinationType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getAssociationType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssociationEdgeType] =
      AwsError.unwrapOptionField("associationType", associationType)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SortAssociationsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest
  ) extends zio.aws.sagemaker.model.ListAssociationsRequest.ReadOnly {
    override val sourceArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val destinationArn: Optional[AssociationEntityArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AssociationEntityArn(value)
        )
    override val sourceType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val destinationType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val associationType
        : Optional[zio.aws.sagemaker.model.AssociationEdgeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationType())
        .map(value => zio.aws.sagemaker.model.AssociationEdgeType.wrap(value))
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.SortAssociationsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SortAssociationsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest
  ): zio.aws.sagemaker.model.ListAssociationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
