package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  Timestamp,
  CodeRepositoryNameContains,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCodeRepositoriesRequest(
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    lastModifiedTimeAfter: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimeBefore: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[CodeRepositoryNameContains] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.CodeRepositorySortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.CodeRepositorySortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest = {
    import ListCodeRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          CodeRepositoryNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListCodeRepositoriesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListCodeRepositoriesRequest.wrap(buildAwsValue())
}
object ListCodeRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCodeRepositoriesRequest =
      zio.aws.sagemaker.model.ListCodeRepositoriesRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def lastModifiedTimeAfter: Optional[Timestamp]
    def lastModifiedTimeBefore: Optional[Timestamp]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[CodeRepositoryNameContains]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.sagemaker.model.CodeRepositorySortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.CodeRepositorySortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, CodeRepositoryNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CodeRepositorySortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CodeRepositorySortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest
  ) extends zio.aws.sagemaker.model.ListCodeRepositoriesRequest.ReadOnly {
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeAfter: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[CodeRepositoryNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameContains(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.CodeRepositorySortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.CodeRepositorySortBy.wrap(value))
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.CodeRepositorySortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value =>
          zio.aws.sagemaker.model.CodeRepositorySortOrder.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest
  ): zio.aws.sagemaker.model.ListCodeRepositoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
