package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCodeRepositoriesResponse(
    codeRepositorySummaryList: Iterable[
      zio.aws.sagemaker.model.CodeRepositorySummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse = {
    import ListCodeRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse
      .builder()
      .codeRepositorySummaryList(codeRepositorySummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListCodeRepositoriesResponse.wrap(buildAwsValue())
}
object ListCodeRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCodeRepositoriesResponse =
      zio.aws.sagemaker.model.ListCodeRepositoriesResponse(
        codeRepositorySummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def codeRepositorySummaryList
        : List[zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getCodeRepositorySummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly
    ]] = ZIO.succeed(codeRepositorySummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse
  ) extends zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly {
    override val codeRepositorySummaryList
        : List[zio.aws.sagemaker.model.CodeRepositorySummary.ReadOnly] = impl
      .codeRepositorySummaryList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.CodeRepositorySummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse
  ): zio.aws.sagemaker.model.ListCodeRepositoriesResponse.ReadOnly =
    new Wrapper(impl)
}
