package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  NameContains,
  LastModifiedTime,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCompilationJobsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    lastModifiedTimeAfter: Optional[LastModifiedTime] = Optional.Absent,
    lastModifiedTimeBefore: Optional[LastModifiedTime] = Optional.Absent,
    nameContains: Optional[NameContains] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.CompilationJobStatus] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.ListCompilationJobsSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest = {
    import ListCompilationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListCompilationJobsRequest.wrap(buildAwsValue())
}
object ListCompilationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCompilationJobsRequest =
      zio.aws.sagemaker.model.ListCompilationJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        nameContains.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def lastModifiedTimeAfter: Optional[LastModifiedTime]
    def lastModifiedTimeBefore: Optional[LastModifiedTime]
    def nameContains: Optional[NameContains]
    def statusEquals: Optional[zio.aws.sagemaker.model.CompilationJobStatus]
    def sortBy: Optional[zio.aws.sagemaker.model.ListCompilationJobsSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompilationJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListCompilationJobsSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ) extends zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeAfter: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val lastModifiedTimeBefore: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val nameContains: Optional[NameContains] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.CompilationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.CompilationJobStatus.wrap(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.ListCompilationJobsSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.ListCompilationJobsSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest
  ): zio.aws.sagemaker.model.ListCompilationJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
