package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListLineageGroupsResponse(
    lineageGroupSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.LineageGroupSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse = {
    import ListLineageGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse
      .builder()
      .optionallyWith(
        lineageGroupSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineageGroupSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListLineageGroupsResponse.wrap(buildAwsValue())
}
object ListLineageGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListLineageGroupsResponse =
      zio.aws.sagemaker.model.ListLineageGroupsResponse(
        lineageGroupSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lineageGroupSummaries
        : Optional[List[zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLineageGroupSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("lineageGroupSummaries", lineageGroupSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse
  ) extends zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly {
    override val lineageGroupSummaries
        : Optional[List[zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.LineageGroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse
  ): zio.aws.sagemaker.model.ListLineageGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
