package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPipelinesResponse(
    pipelineSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.PipelineSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse
      .builder()
      .optionallyWith(
        pipelineSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelinesResponse =
      zio.aws.sagemaker.model.ListPipelinesResponse(
        pipelineSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pipelineSummaries
        : Optional[List[zio.aws.sagemaker.model.PipelineSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPipelineSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.PipelineSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelineSummaries", pipelineSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse
  ) extends zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly {
    override val pipelineSummaries
        : Optional[List[zio.aws.sagemaker.model.PipelineSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.PipelineSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse
  ): zio.aws.sagemaker.model.ListPipelinesResponse.ReadOnly = new Wrapper(impl)
}
