package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, MetricName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MetricData(
    metricName: Optional[MetricName] = Optional.Absent,
    value: Optional[Float] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricData = {
    import MetricData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricData
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(value.map(value => value: java.lang.Float))(_.value)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricData.ReadOnly =
    zio.aws.sagemaker.model.MetricData.wrap(buildAwsValue())
}
object MetricData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricData =
      zio.aws.sagemaker.model.MetricData(
        metricName.map(value => value),
        value.map(value => value),
        timestamp.map(value => value)
      )
    def metricName: Optional[MetricName]
    def value: Optional[Float]
    def timestamp: Optional[Timestamp]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("value", value)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricData
  ) extends zio.aws.sagemaker.model.MetricData.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.sagemaker.model.primitives.MetricName(value))
    override val value: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Float)
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricData
  ): zio.aws.sagemaker.model.MetricData.ReadOnly = new Wrapper(impl)
}
