package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait MetricSetSource {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.MetricSetSource
}
object MetricSetSource {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.MetricSetSource
  ): zio.aws.sagemaker.model.MetricSetSource = value match {
    case software.amazon.awssdk.services.sagemaker.model.MetricSetSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.MetricSetSource.TRAIN =>
      val r = Train
      r
    case software.amazon.awssdk.services.sagemaker.model.MetricSetSource.VALIDATION =>
      val r = Validation
      r
    case software.amazon.awssdk.services.sagemaker.model.MetricSetSource.TEST =>
      val r = Test
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.MetricSetSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MetricSetSource =
      software.amazon.awssdk.services.sagemaker.model.MetricSetSource.UNKNOWN_TO_SDK_VERSION
  }
  case object Train extends zio.aws.sagemaker.model.MetricSetSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MetricSetSource =
      software.amazon.awssdk.services.sagemaker.model.MetricSetSource.TRAIN
  }
  case object Validation extends zio.aws.sagemaker.model.MetricSetSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MetricSetSource =
      software.amazon.awssdk.services.sagemaker.model.MetricSetSource.VALIDATION
  }
  case object Test extends zio.aws.sagemaker.model.MetricSetSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MetricSetSource =
      software.amazon.awssdk.services.sagemaker.model.MetricSetSource.TEST
  }
}
