package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.InferenceSpecificationName
import scala.jdk.CollectionConverters._
final case class ModelConfiguration(
    inferenceSpecificationName: Optional[InferenceSpecificationName] =
      Optional.Absent,
    environmentParameters: Optional[
      Iterable[zio.aws.sagemaker.model.EnvironmentParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelConfiguration = {
    import ModelConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelConfiguration
      .builder()
      .optionallyWith(
        inferenceSpecificationName.map(value =>
          InferenceSpecificationName.unwrap(value): java.lang.String
        )
      )(_.inferenceSpecificationName)
      .optionallyWith(
        environmentParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelConfiguration.ReadOnly =
    zio.aws.sagemaker.model.ModelConfiguration.wrap(buildAwsValue())
}
object ModelConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelConfiguration =
      zio.aws.sagemaker.model.ModelConfiguration(
        inferenceSpecificationName.map(value => value),
        environmentParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inferenceSpecificationName: Optional[InferenceSpecificationName]
    def environmentParameters
        : Optional[List[zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly]]
    def getInferenceSpecificationName
        : ZIO[Any, AwsError, InferenceSpecificationName] =
      AwsError.unwrapOptionField(
        "inferenceSpecificationName",
        inferenceSpecificationName
      )
    def getEnvironmentParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentParameters", environmentParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelConfiguration
  ) extends zio.aws.sagemaker.model.ModelConfiguration.ReadOnly {
    override val inferenceSpecificationName
        : Optional[InferenceSpecificationName] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSpecificationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InferenceSpecificationName(value)
      )
    override val environmentParameters: Optional[
      List[zio.aws.sagemaker.model.EnvironmentParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.EnvironmentParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelConfiguration
  ): zio.aws.sagemaker.model.ModelConfiguration.ReadOnly = new Wrapper(impl)
}
