package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelPackageStatusDetails(
    validationStatuses: Iterable[
      zio.aws.sagemaker.model.ModelPackageStatusItem
    ],
    imageScanStatuses: Optional[
      Iterable[zio.aws.sagemaker.model.ModelPackageStatusItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails = {
    import ModelPackageStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails
      .builder()
      .validationStatuses(validationStatuses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        imageScanStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageScanStatuses)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageStatusDetails.wrap(buildAwsValue())
}
object ModelPackageStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageStatusDetails =
      zio.aws.sagemaker.model.ModelPackageStatusDetails(
        validationStatuses.map { item =>
          item.asEditable
        },
        imageScanStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def validationStatuses
        : List[zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly]
    def imageScanStatuses: Optional[
      List[zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly]
    ]
    def getValidationStatuses: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly
    ]] = ZIO.succeed(validationStatuses)
    def getImageScanStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly
    ]] = AwsError.unwrapOptionField("imageScanStatuses", imageScanStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails
  ) extends zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly {
    override val validationStatuses
        : List[zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly] = impl
      .validationStatuses()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelPackageStatusItem.wrap(item)
      }
      .toList
    override val imageScanStatuses: Optional[
      List[zio.aws.sagemaker.model.ModelPackageStatusItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageScanStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ModelPackageStatusItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails
  ): zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly = new Wrapper(
    impl
  )
}
