package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters._
final case class ModelPackageValidationSpecification(
    validationRole: RoleArn,
    validationProfiles: Iterable[
      zio.aws.sagemaker.model.ModelPackageValidationProfile
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification = {
    import ModelPackageValidationSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification
      .builder()
      .validationRole(RoleArn.unwrap(validationRole): java.lang.String)
      .validationProfiles(validationProfiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageValidationSpecification
      .wrap(buildAwsValue())
}
object ModelPackageValidationSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ModelPackageValidationSpecification =
      zio.aws.sagemaker.model.ModelPackageValidationSpecification(
        validationRole,
        validationProfiles.map { item =>
          item.asEditable
        }
      )
    def validationRole: RoleArn
    def validationProfiles
        : List[zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly]
    def getValidationRole: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(validationRole)
    def getValidationProfiles: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly
    ]] = ZIO.succeed(validationProfiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification
  ) extends zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly {
    override val validationRole: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.validationRole())
    override val validationProfiles
        : List[zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly] =
      impl
        .validationProfiles()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.ModelPackageValidationProfile.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification
  ): zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly =
    new Wrapper(impl)
}
