package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  S3Uri,
  ContainerArgument,
  ContainerEntrypointString,
  ImageUri
}
import scala.jdk.CollectionConverters._
final case class MonitoringAppSpecification(
    imageUri: ImageUri,
    containerEntrypoint: Optional[Iterable[ContainerEntrypointString]] =
      Optional.Absent,
    containerArguments: Optional[Iterable[ContainerArgument]] = Optional.Absent,
    recordPreprocessorSourceUri: Optional[S3Uri] = Optional.Absent,
    postAnalyticsProcessorSourceUri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification = {
    import MonitoringAppSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .optionallyWith(
        containerEntrypoint.map(value =>
          value.map { item =>
            ContainerEntrypointString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerEntrypoint)
      .optionallyWith(
        containerArguments.map(value =>
          value.map { item =>
            ContainerArgument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerArguments)
      .optionallyWith(
        recordPreprocessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.recordPreprocessorSourceUri)
      .optionallyWith(
        postAnalyticsProcessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.postAnalyticsProcessorSourceUri)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly =
    zio.aws.sagemaker.model.MonitoringAppSpecification.wrap(buildAwsValue())
}
object MonitoringAppSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringAppSpecification =
      zio.aws.sagemaker.model.MonitoringAppSpecification(
        imageUri,
        containerEntrypoint.map(value => value),
        containerArguments.map(value => value),
        recordPreprocessorSourceUri.map(value => value),
        postAnalyticsProcessorSourceUri.map(value => value)
      )
    def imageUri: ImageUri
    def containerEntrypoint: Optional[List[ContainerEntrypointString]]
    def containerArguments: Optional[List[ContainerArgument]]
    def recordPreprocessorSourceUri: Optional[S3Uri]
    def postAnalyticsProcessorSourceUri: Optional[S3Uri]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getContainerEntrypoint
        : ZIO[Any, AwsError, List[ContainerEntrypointString]] =
      AwsError.unwrapOptionField("containerEntrypoint", containerEntrypoint)
    def getContainerArguments: ZIO[Any, AwsError, List[ContainerArgument]] =
      AwsError.unwrapOptionField("containerArguments", containerArguments)
    def getRecordPreprocessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "recordPreprocessorSourceUri",
        recordPreprocessorSourceUri
      )
    def getPostAnalyticsProcessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "postAnalyticsProcessorSourceUri",
        postAnalyticsProcessorSourceUri
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification
  ) extends zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.sagemaker.model.primitives.ImageUri(impl.imageUri())
    override val containerEntrypoint
        : Optional[List[ContainerEntrypointString]] = zio.aws.core.internal
      .optionalFromNullable(impl.containerEntrypoint())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.ContainerEntrypointString(item)
        }.toList
      )
    override val containerArguments: Optional[List[ContainerArgument]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerArguments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ContainerArgument(item)
          }.toList
        )
    override val recordPreprocessorSourceUri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordPreprocessorSourceUri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val postAnalyticsProcessorSourceUri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postAnalyticsProcessorSourceUri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAppSpecification
  ): zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly = new Wrapper(
    impl
  )
}
