package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  ProcessingJobArn,
  MonitoringJobDefinitionName,
  MonitoringScheduleName,
  Timestamp,
  FailureReason
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MonitoringExecutionSummary(
    monitoringScheduleName: MonitoringScheduleName,
    scheduledTime: Timestamp,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    monitoringExecutionStatus: zio.aws.sagemaker.model.ExecutionStatus,
    processingJobArn: Optional[ProcessingJobArn] = Optional.Absent,
    endpointName: Optional[EndpointName] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName] =
      Optional.Absent,
    monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary = {
    import MonitoringExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .scheduledTime(Timestamp.unwrap(scheduledTime): Instant)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .monitoringExecutionStatus(monitoringExecutionStatus.unwrap)
      .optionallyWith(
        processingJobArn.map(value =>
          ProcessingJobArn.unwrap(value): java.lang.String
        )
      )(_.processingJobArn)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        monitoringJobDefinitionName.map(value =>
          MonitoringJobDefinitionName.unwrap(value): java.lang.String
        )
      )(_.monitoringJobDefinitionName)
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly =
    zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(buildAwsValue())
}
object MonitoringExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringExecutionSummary =
      zio.aws.sagemaker.model.MonitoringExecutionSummary(
        monitoringScheduleName,
        scheduledTime,
        creationTime,
        lastModifiedTime,
        monitoringExecutionStatus,
        processingJobArn.map(value => value),
        endpointName.map(value => value),
        failureReason.map(value => value),
        monitoringJobDefinitionName.map(value => value),
        monitoringType.map(value => value)
      )
    def monitoringScheduleName: MonitoringScheduleName
    def scheduledTime: Timestamp
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def monitoringExecutionStatus: zio.aws.sagemaker.model.ExecutionStatus
    def processingJobArn: Optional[ProcessingJobArn]
    def endpointName: Optional[EndpointName]
    def failureReason: Optional[FailureReason]
    def monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName]
    def monitoringType: Optional[zio.aws.sagemaker.model.MonitoringType]
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getScheduledTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(scheduledTime)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getMonitoringExecutionStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ExecutionStatus] =
      ZIO.succeed(monitoringExecutionStatus)
    def getProcessingJobArn: ZIO[Any, AwsError, ProcessingJobArn] =
      AwsError.unwrapOptionField("processingJobArn", processingJobArn)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getMonitoringJobDefinitionName
        : ZIO[Any, AwsError, MonitoringJobDefinitionName] =
      AwsError.unwrapOptionField(
        "monitoringJobDefinitionName",
        monitoringJobDefinitionName
      )
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary
  ) extends zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val scheduledTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.scheduledTime())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val monitoringExecutionStatus
        : zio.aws.sagemaker.model.ExecutionStatus =
      zio.aws.sagemaker.model.ExecutionStatus
        .wrap(impl.monitoringExecutionStatus())
    override val processingJobArn: Optional[ProcessingJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingJobArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProcessingJobArn(value)
        )
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val monitoringJobDefinitionName
        : Optional[MonitoringJobDefinitionName] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringJobDefinitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName(value)
      )
    override val monitoringType
        : Optional[zio.aws.sagemaker.model.MonitoringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringType())
        .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary
  ): zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
