package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ProcessingEnvironmentValue,
  ProcessingEnvironmentKey
}
import scala.jdk.CollectionConverters._
final case class MonitoringJobDefinition(
    baselineConfig: Optional[zio.aws.sagemaker.model.MonitoringBaselineConfig] =
      Optional.Absent,
    monitoringInputs: Iterable[zio.aws.sagemaker.model.MonitoringInput],
    monitoringOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    monitoringResources: zio.aws.sagemaker.model.MonitoringResources,
    monitoringAppSpecification: zio.aws.sagemaker.model.MonitoringAppSpecification,
    stoppingCondition: Optional[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = Optional.Absent,
    environment: Optional[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = Optional.Absent,
    networkConfig: Optional[zio.aws.sagemaker.model.NetworkConfig] =
      Optional.Absent,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition = {
    import MonitoringJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition
      .builder()
      .optionallyWith(baselineConfig.map(value => value.buildAwsValue()))(
        _.baselineConfig
      )
      .monitoringInputs(monitoringInputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .monitoringOutputConfig(monitoringOutputConfig.buildAwsValue())
      .monitoringResources(monitoringResources.buildAwsValue())
      .monitoringAppSpecification(monitoringAppSpecification.buildAwsValue())
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (ProcessingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly =
    zio.aws.sagemaker.model.MonitoringJobDefinition.wrap(buildAwsValue())
}
object MonitoringJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringJobDefinition =
      zio.aws.sagemaker.model.MonitoringJobDefinition(
        baselineConfig.map(value => value.asEditable),
        monitoringInputs.map { item =>
          item.asEditable
        },
        monitoringOutputConfig.asEditable,
        monitoringResources.asEditable,
        monitoringAppSpecification.asEditable,
        stoppingCondition.map(value => value.asEditable),
        environment.map(value => value),
        networkConfig.map(value => value.asEditable),
        roleArn
      )
    def baselineConfig
        : Optional[zio.aws.sagemaker.model.MonitoringBaselineConfig.ReadOnly]
    def monitoringInputs: List[zio.aws.sagemaker.model.MonitoringInput.ReadOnly]
    def monitoringOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def monitoringResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def monitoringAppSpecification
        : zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly
    def stoppingCondition
        : Optional[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def networkConfig: Optional[zio.aws.sagemaker.model.NetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def getBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField("baselineConfig", baselineConfig)
    def getMonitoringInputs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringInput.ReadOnly
    ]] = ZIO.succeed(monitoringInputs)
    def getMonitoringOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(monitoringOutputConfig)
    def getMonitoringResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(monitoringResources)
    def getMonitoringAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly
    ] = ZIO.succeed(monitoringAppSpecification)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getNetworkConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition
  ) extends zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly {
    override val baselineConfig
        : Optional[zio.aws.sagemaker.model.MonitoringBaselineConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringBaselineConfig.wrap(value)
        )
    override val monitoringInputs
        : List[zio.aws.sagemaker.model.MonitoringInput.ReadOnly] = impl
      .monitoringInputs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MonitoringInput.wrap(item)
      }
      .toList
    override val monitoringOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.monitoringOutputConfig())
    override val monitoringResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources
        .wrap(impl.monitoringResources())
    override val monitoringAppSpecification
        : zio.aws.sagemaker.model.MonitoringAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.MonitoringAppSpecification
        .wrap(impl.monitoringAppSpecification())
    override val stoppingCondition: Optional[
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingCondition())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
      )
    override val environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
    override val networkConfig
        : Optional[zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfig())
        .map(value => zio.aws.sagemaker.model.NetworkConfig.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinition
  ): zio.aws.sagemaker.model.MonitoringJobDefinition.ReadOnly = new Wrapper(
    impl
  )
}
