package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  Timestamp,
  MonitoringJobDefinitionArn,
  MonitoringJobDefinitionName
}
import scala.jdk.CollectionConverters._
final case class MonitoringJobDefinitionSummary(
    monitoringJobDefinitionName: MonitoringJobDefinitionName,
    monitoringJobDefinitionArn: MonitoringJobDefinitionArn,
    creationTime: Timestamp,
    endpointName: EndpointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary = {
    import MonitoringJobDefinitionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary
      .builder()
      .monitoringJobDefinitionName(
        MonitoringJobDefinitionName.unwrap(
          monitoringJobDefinitionName
        ): java.lang.String
      )
      .monitoringJobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(
          monitoringJobDefinitionArn
        ): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly =
    zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(buildAwsValue())
}
object MonitoringJobDefinitionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringJobDefinitionSummary =
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary(
        monitoringJobDefinitionName,
        monitoringJobDefinitionArn,
        creationTime,
        endpointName
      )
    def monitoringJobDefinitionName: MonitoringJobDefinitionName
    def monitoringJobDefinitionArn: MonitoringJobDefinitionArn
    def creationTime: Timestamp
    def endpointName: EndpointName
    def getMonitoringJobDefinitionName
        : ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(monitoringJobDefinitionName)
    def getMonitoringJobDefinitionArn
        : ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(monitoringJobDefinitionArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary
  ) extends zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly {
    override val monitoringJobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.monitoringJobDefinitionName())
    override val monitoringJobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.monitoringJobDefinitionArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary
  ): zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly =
    new Wrapper(impl)
}
