package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ResourcePropertyName
import scala.jdk.CollectionConverters._
final case class NestedFilters(
    nestedPropertyName: ResourcePropertyName,
    filters: Iterable[zio.aws.sagemaker.model.Filter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NestedFilters = {
    import NestedFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NestedFilters
      .builder()
      .nestedPropertyName(
        ResourcePropertyName.unwrap(nestedPropertyName): java.lang.String
      )
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NestedFilters.ReadOnly =
    zio.aws.sagemaker.model.NestedFilters.wrap(buildAwsValue())
}
object NestedFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NestedFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NestedFilters =
      zio.aws.sagemaker.model.NestedFilters(
        nestedPropertyName,
        filters.map { item =>
          item.asEditable
        }
      )
    def nestedPropertyName: ResourcePropertyName
    def filters: List[zio.aws.sagemaker.model.Filter.ReadOnly]
    def getNestedPropertyName: ZIO[Any, Nothing, ResourcePropertyName] =
      ZIO.succeed(nestedPropertyName)
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NestedFilters
  ) extends zio.aws.sagemaker.model.NestedFilters.ReadOnly {
    override val nestedPropertyName: ResourcePropertyName =
      zio.aws.sagemaker.model.primitives
        .ResourcePropertyName(impl.nestedPropertyName())
    override val filters: List[zio.aws.sagemaker.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.Filter.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NestedFilters
  ): zio.aws.sagemaker.model.NestedFilters.ReadOnly = new Wrapper(impl)
}
