package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait NotebookInstanceAcceleratorType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType
}
object NotebookInstanceAcceleratorType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType
  ): zio.aws.sagemaker.model.NotebookInstanceAcceleratorType = value match {
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_MEDIUM =>
      val r = `ml.eia1.medium`
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_LARGE =>
      val r = `ml.eia1.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_XLARGE =>
      val r = `ml.eia1.xlarge`
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_MEDIUM =>
      val r = `ml.eia2.medium`
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_LARGE =>
      val r = `ml.eia2.large`
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_XLARGE =>
      val r = `ml.eia2.xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ml.eia1.medium`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_MEDIUM
  }
  case object `ml.eia1.large`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_LARGE
  }
  case object `ml.eia1.xlarge`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA1_XLARGE
  }
  case object `ml.eia2.medium`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_MEDIUM
  }
  case object `ml.eia2.large`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_LARGE
  }
  case object `ml.eia2.xlarge`
      extends zio.aws.sagemaker.model.NotebookInstanceAcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceAcceleratorType.ML_EIA2_XLARGE
  }
}
