package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait NotebookInstanceLifecycleConfigSortKey {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
}
object NotebookInstanceLifecycleConfigSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
  ): zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey =
    value match {
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.NAME =>
        val r = Name
        r
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.CREATION_TIME =>
        val r = CreationTime
        r
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.LAST_MODIFIED_TIME =>
        val r = LastModifiedTime
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.NAME
  }
  case object CreationTime
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.CREATION_TIME
  }
  case object LastModifiedTime
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortKey.LAST_MODIFIED_TIME
  }
}
