package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait NotebookInstanceLifecycleConfigSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
}
object NotebookInstanceLifecycleConfigSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
  ): zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder =
    value match {
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.ASCENDING =>
        val r = Ascending
        r
      case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.DESCENDING =>
        val r = Descending
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.ASCENDING
  }
  case object Descending
      extends zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder.DESCENDING
  }
}
