package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait NotebookInstanceSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder
}
object NotebookInstanceSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder
  ): zio.aws.sagemaker.model.NotebookInstanceSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending
      extends zio.aws.sagemaker.model.NotebookInstanceSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.ASCENDING
  }
  case object Descending
      extends zio.aws.sagemaker.model.NotebookInstanceSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortOrder.DESCENDING
  }
}
