package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{OidcEndpoint, ClientId}
import scala.jdk.CollectionConverters._
final case class OidcConfigForResponse(
    clientId: Optional[ClientId] = Optional.Absent,
    issuer: Optional[OidcEndpoint] = Optional.Absent,
    authorizationEndpoint: Optional[OidcEndpoint] = Optional.Absent,
    tokenEndpoint: Optional[OidcEndpoint] = Optional.Absent,
    userInfoEndpoint: Optional[OidcEndpoint] = Optional.Absent,
    logoutEndpoint: Optional[OidcEndpoint] = Optional.Absent,
    jwksUri: Optional[OidcEndpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse = {
    import OidcConfigForResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        issuer.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        authorizationEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.authorizationEndpoint)
      .optionallyWith(
        tokenEndpoint.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.tokenEndpoint)
      .optionallyWith(
        userInfoEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.userInfoEndpoint)
      .optionallyWith(
        logoutEndpoint.map(value =>
          OidcEndpoint.unwrap(value): java.lang.String
        )
      )(_.logoutEndpoint)
      .optionallyWith(
        jwksUri.map(value => OidcEndpoint.unwrap(value): java.lang.String)
      )(_.jwksUri)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly =
    zio.aws.sagemaker.model.OidcConfigForResponse.wrap(buildAwsValue())
}
object OidcConfigForResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OidcConfigForResponse =
      zio.aws.sagemaker.model.OidcConfigForResponse(
        clientId.map(value => value),
        issuer.map(value => value),
        authorizationEndpoint.map(value => value),
        tokenEndpoint.map(value => value),
        userInfoEndpoint.map(value => value),
        logoutEndpoint.map(value => value),
        jwksUri.map(value => value)
      )
    def clientId: Optional[ClientId]
    def issuer: Optional[OidcEndpoint]
    def authorizationEndpoint: Optional[OidcEndpoint]
    def tokenEndpoint: Optional[OidcEndpoint]
    def userInfoEndpoint: Optional[OidcEndpoint]
    def logoutEndpoint: Optional[OidcEndpoint]
    def jwksUri: Optional[OidcEndpoint]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getIssuer: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getAuthorizationEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("authorizationEndpoint", authorizationEndpoint)
    def getTokenEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("tokenEndpoint", tokenEndpoint)
    def getUserInfoEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("userInfoEndpoint", userInfoEndpoint)
    def getLogoutEndpoint: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("logoutEndpoint", logoutEndpoint)
    def getJwksUri: ZIO[Any, AwsError, OidcEndpoint] =
      AwsError.unwrapOptionField("jwksUri", jwksUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ) extends zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly {
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.sagemaker.model.primitives.ClientId(value))
    override val issuer: Optional[OidcEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val authorizationEndpoint: Optional[OidcEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationEndpoint())
        .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val tokenEndpoint: Optional[OidcEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val userInfoEndpoint: Optional[OidcEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userInfoEndpoint())
        .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val logoutEndpoint: Optional[OidcEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.logoutEndpoint())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
    override val jwksUri: Optional[OidcEndpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.jwksUri())
      .map(value => zio.aws.sagemaker.model.primitives.OidcEndpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfigForResponse
  ): zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly = new Wrapper(impl)
}
