package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters._
final case class OnlineStoreSecurityConfig(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig = {
    import OnlineStoreSecurityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly =
    zio.aws.sagemaker.model.OnlineStoreSecurityConfig.wrap(buildAwsValue())
}
object OnlineStoreSecurityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OnlineStoreSecurityConfig =
      zio.aws.sagemaker.model
        .OnlineStoreSecurityConfig(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[KmsKeyId]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig
  ) extends zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreSecurityConfig
  ): zio.aws.sagemaker.model.OnlineStoreSecurityConfig.ReadOnly = new Wrapper(
    impl
  )
}
