package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, EndpointConfigName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PendingDeploymentSummary(
    endpointConfigName: EndpointConfigName,
    productionVariants: Optional[
      Iterable[zio.aws.sagemaker.model.PendingProductionVariantSummary]
    ] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary = {
    import PendingDeploymentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .optionallyWith(
        productionVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productionVariants)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly =
    zio.aws.sagemaker.model.PendingDeploymentSummary.wrap(buildAwsValue())
}
object PendingDeploymentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PendingDeploymentSummary =
      zio.aws.sagemaker.model.PendingDeploymentSummary(
        endpointConfigName,
        productionVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value)
      )
    def endpointConfigName: EndpointConfigName
    def productionVariants: Optional[
      List[zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly]
    ]
    def startTime: Optional[Timestamp]
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getProductionVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("productionVariants", productionVariants)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary
  ) extends zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val productionVariants: Optional[
      List[zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.productionVariants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.PendingProductionVariantSummary.wrap(item)
        }.toList
      )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingDeploymentSummary
  ): zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly = new Wrapper(
    impl
  )
}
