package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TaskCount,
  VariantWeight,
  VariantName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PendingProductionVariantSummary(
    variantName: VariantName,
    deployedImages: Optional[Iterable[zio.aws.sagemaker.model.DeployedImage]] =
      Optional.Absent,
    currentWeight: Optional[VariantWeight] = Optional.Absent,
    desiredWeight: Optional[VariantWeight] = Optional.Absent,
    currentInstanceCount: Optional[TaskCount] = Optional.Absent,
    desiredInstanceCount: Optional[TaskCount] = Optional.Absent,
    instanceType: Optional[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = Optional.Absent,
    acceleratorType: Optional[
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = Optional.Absent,
    variantStatus: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariantStatus]
    ] = Optional.Absent,
    currentServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = Optional.Absent,
    desiredServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary = {
    import PendingProductionVariantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .optionallyWith(
        deployedImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployedImages)
      .optionallyWith(
        currentWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.currentWeight)
      .optionallyWith(
        desiredWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.desiredWeight)
      .optionallyWith(
        currentInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.currentInstanceCount)
      .optionallyWith(
        desiredInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.desiredInstanceCount)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(acceleratorType.map(value => value.unwrap))(
        _.acceleratorType
      )
      .optionallyWith(
        variantStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variantStatus)
      .optionallyWith(
        currentServerlessConfig.map(value => value.buildAwsValue())
      )(_.currentServerlessConfig)
      .optionallyWith(
        desiredServerlessConfig.map(value => value.buildAwsValue())
      )(_.desiredServerlessConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly =
    zio.aws.sagemaker.model.PendingProductionVariantSummary
      .wrap(buildAwsValue())
}
object PendingProductionVariantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PendingProductionVariantSummary =
      zio.aws.sagemaker.model.PendingProductionVariantSummary(
        variantName,
        deployedImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentWeight.map(value => value),
        desiredWeight.map(value => value),
        currentInstanceCount.map(value => value),
        desiredInstanceCount.map(value => value),
        instanceType.map(value => value),
        acceleratorType.map(value => value),
        variantStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentServerlessConfig.map(value => value.asEditable),
        desiredServerlessConfig.map(value => value.asEditable)
      )
    def variantName: VariantName
    def deployedImages
        : Optional[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]]
    def currentWeight: Optional[VariantWeight]
    def desiredWeight: Optional[VariantWeight]
    def currentInstanceCount: Optional[TaskCount]
    def desiredInstanceCount: Optional[TaskCount]
    def instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def acceleratorType
        : Optional[zio.aws.sagemaker.model.ProductionVariantAcceleratorType]
    def variantStatus: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]
    ]
    def currentServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def desiredServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getDeployedImages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DeployedImage.ReadOnly
    ]] = AwsError.unwrapOptionField("deployedImages", deployedImages)
    def getCurrentWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("currentWeight", currentWeight)
    def getDesiredWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("desiredWeight", desiredWeight)
    def getCurrentInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("currentInstanceCount", currentInstanceCount)
    def getDesiredInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("desiredInstanceCount", desiredInstanceCount)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getAcceleratorType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getVariantStatus: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("variantStatus", variantStatus)
    def getCurrentServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentServerlessConfig",
      currentServerlessConfig
    )
    def getDesiredServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "desiredServerlessConfig",
      desiredServerlessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ) extends zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val deployedImages
        : Optional[List[zio.aws.sagemaker.model.DeployedImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployedImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.DeployedImage.wrap(item)
          }.toList
        )
    override val currentWeight: Optional[VariantWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.currentWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val desiredWeight: Optional[VariantWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val currentInstanceCount: Optional[TaskCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInstanceCount())
        .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val desiredInstanceCount: Optional[TaskCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredInstanceCount())
        .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
    override val instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
        )
    override val acceleratorType
        : Optional[zio.aws.sagemaker.model.ProductionVariantAcceleratorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantAcceleratorType.wrap(value)
        )
    override val variantStatus: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.variantStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantStatus.wrap(item)
        }.toList
      )
    override val currentServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
    override val desiredServerlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredServerlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary
  ): zio.aws.sagemaker.model.PendingProductionVariantSummary.ReadOnly =
    new Wrapper(impl)
}
